/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;

public class CollectionResolver
implements CollectionURIResolver {
    XProcRuntime runtime = null;
    Vector<XdmNode> docs = null;
    CollectionURIResolver chainedResolver = null;
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    public CollectionResolver(XProcRuntime runtime, Vector<XdmNode> docs, CollectionURIResolver chainedResolver) {
        this.runtime = runtime;
        this.docs = docs;
        this.chainedResolver = chainedResolver;
    }

    @Override
    public SequenceIterator resolve(String href, String base, XPathContext context) throws XPathException {
        this.runtime.finest(null, null, "Collection: " + href + " (" + base + ")");
        if (href == null) {
            Item[] array = new Item[this.docs.size()];
            int pos = 0;
            while (pos < this.docs.size()) {
                array[pos] = this.docs.get(pos).getUnderlyingNode();
                ++pos;
            }
            return new ArrayIterator(array);
        }
        try {
            URI hrefuri = base == null ? new URI(href) : new URI(base).resolve(href);
            Vector<XdmNode> docs = this.runtime.getCollection(hrefuri);
            if (docs != null) {
                Item[] items = new Item[docs.size()];
                int pos = 0;
                while (pos < docs.size()) {
                    items[pos] = docs.get(pos).getUnderlyingNode();
                    ++pos;
                }
                return new ArrayIterator(items);
            }
        }
        catch (URISyntaxException use) {
            this.runtime.finest(null, null, "URI Syntax exception resolving collection URI: " + href + " (" + base + ")");
        }
        return this.chainedResolver.resolve(href, base, context);
    }
}

