/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class DefaultXProcMessageListener
implements XProcMessageListener {
    private static Logger defaultLogger = Logger.getLogger("com.xmlcalabash");
    private Logger log = defaultLogger;

    @Override
    public void error(XProcRunnable step, XdmNode node, String message, QName code) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.severe(this.message(step, node, message, code));
    }

    @Override
    public void error(Throwable exception) {
        this.log.severe(String.valueOf(this.exceptionMessage(exception)) + exception.getMessage());
    }

    private String exceptionMessage(Throwable exception) {
        StructuredQName qCode = null;
        SourceLocator loc = null;
        String message = "";
        if (exception instanceof XPathException) {
            qCode = ((XPathException)exception).getErrorCodeQName();
        }
        if (exception instanceof TransformerException) {
            TransformerException tx = (TransformerException)exception;
            if (qCode == null && tx.getException() instanceof XPathException) {
                qCode = ((XPathException)tx.getException()).getErrorCodeQName();
            }
            if (tx.getLocator() != null) {
                loc = tx.getLocator();
                boolean done = false;
                while (!done && loc == null) {
                    if (tx.getException() instanceof TransformerException) {
                        tx = (TransformerException)tx.getException();
                        loc = tx.getLocator();
                        continue;
                    }
                    if (exception.getCause() instanceof TransformerException) {
                        tx = (TransformerException)exception.getCause();
                        loc = tx.getLocator();
                        continue;
                    }
                    done = true;
                }
            }
        }
        if (exception instanceof XProcException) {
            XProcException err = (XProcException)exception;
            loc = err.getLocator();
            if (err.getErrorCode() != null) {
                QName n = err.getErrorCode();
                qCode = new StructuredQName(n.getPrefix(), n.getNamespaceURI(), n.getLocalName());
            }
            if (err.getStep() != null) {
                message = String.valueOf(message) + err.getStep() + ":";
            }
        }
        if (loc != null) {
            if (loc.getSystemId() != null && !"".equals(loc.getSystemId())) {
                message = String.valueOf(message) + loc.getSystemId() + ":";
            }
            if (loc.getLineNumber() != -1) {
                message = String.valueOf(message) + loc.getLineNumber() + ":";
            }
            if (loc.getColumnNumber() != -1) {
                message = String.valueOf(message) + loc.getColumnNumber() + ":";
            }
        }
        if (qCode != null) {
            message = String.valueOf(message) + qCode.getDisplayName() + ":";
        }
        return message;
    }

    @Override
    public void warning(XProcRunnable step, XdmNode node, String message) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.warning(this.message(step, node, message));
    }

    @Override
    public void warning(Throwable exception) {
        this.log.warning(String.valueOf(this.exceptionMessage(exception)) + exception.getMessage());
    }

    @Override
    public void info(XProcRunnable step, XdmNode node, String message) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.info(this.message(step, node, message));
    }

    @Override
    public void fine(XProcRunnable step, XdmNode node, String message) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.fine(this.message(step, node, message));
    }

    @Override
    public void finer(XProcRunnable step, XdmNode node, String message) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.finer(this.message(step, node, message));
    }

    @Override
    public void finest(XProcRunnable step, XdmNode node, String message) {
        this.log = step != null ? Logger.getLogger(step.getClass().getName()) : defaultLogger;
        this.log.finest(this.message(step, node, message));
    }

    private String message(XProcRunnable step, XdmNode node, String message) {
        return this.message(step, node, message, null);
    }

    private String message(XProcRunnable step, XdmNode node, String message, QName code) {
        String prefix = "";
        if (node != null) {
            URI cwd = URIUtils.cwdAsURI();
            String systemId = cwd.relativize(node.getBaseURI()).toASCIIString();
            int line = node.getLineNumber();
            int col = node.getColumnNumber();
            if (systemId != null && !"".equals(systemId)) {
                prefix = String.valueOf(prefix) + systemId + ":";
            }
            if (line != -1) {
                prefix = String.valueOf(prefix) + line + ":";
            }
            if (col != -1) {
                prefix = String.valueOf(prefix) + col + ":";
            }
        }
        return String.valueOf(prefix) + message;
    }
}

