/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class MIMEReader {
    private static final int H_NAME = 1;
    private static final int H_VALUE = 2;
    private static final int H_DONE = 3;
    private static final int B_SOL = 4;
    private static final int B_CR = 5;
    private static final int B_MATCHSEP = 6;
    private static final int B_DATA = 7;
    private static final int B_MATCHLAST = 8;
    private InputStream stream = null;
    private String boundary = null;
    private String separator = null;
    private String lastsep = null;
    int peek = -1;
    private Header[] headers;
    private int headerPos = 0;

    public MIMEReader(InputStream stream, String boundary) {
        this.stream = stream;
        this.boundary = boundary;
        this.separator = "--" + boundary;
        this.lastsep = String.valueOf(this.separator) + "--";
        if (this.separator == null) {
            throw new NullPointerException();
        }
        String line = this.getLine();
        if (!this.separator.equals(line)) {
            throw new XProcException("MIME multipart doesn't start with separator?");
        }
    }

    public boolean readHeaders() {
        int headerSize = 5;
        int headergrow = 2;
        this.headers = new Header[headerSize];
        this.headerPos = 0;
        if (this.peekByte() < 0) {
            return false;
        }
        Header h = this.getHeader();
        while (h != null) {
            if (this.headerPos == headerSize) {
                Header[] newheaders = new Header[headerSize + headergrow];
                System.arraycopy(this.headers, 0, newheaders, 0, headerSize);
                this.headers = newheaders;
                headerSize += headergrow;
            }
            this.headers[this.headerPos++] = h;
            h = this.getHeader();
        }
        return true;
    }

    public Header[] getHeaders() {
        Header[] rh = new Header[this.headerPos];
        System.arraycopy(this.headers, 0, rh, 0, this.headerPos);
        return rh;
    }

    public Header getHeader(String name) {
        int pos = 0;
        while (pos < this.headerPos) {
            if (name.toLowerCase().equals(this.headers[pos].getName().toLowerCase())) {
                return this.headers[pos];
            }
            ++pos;
        }
        return null;
    }

    private Header getHeader() {
        String name = "";
        String value = "";
        int state = 1;
        block4: while (state != 3) {
            int b = this.nextByte();
            int peek = this.peekByte();
            if (b == 13) {
                if (peek == 10) {
                    b = this.nextByte();
                    peek = this.peekByte();
                } else {
                    b = 10;
                }
            }
            if (b < 0) {
                throw new XProcException("Got -1 reading stream...");
            }
            switch (state) {
                case 1: {
                    if (b == 10) {
                        state = 3;
                        break;
                    }
                    if (b == 58) {
                        state = 2;
                        break;
                    }
                    name = String.valueOf(name) + (char)b;
                    break;
                }
                case 2: {
                    if (b == 10) {
                        if (peek == 32 || peek == 9) continue block4;
                        state = 3;
                        break;
                    }
                    value = String.valueOf(value) + (char)b;
                    break;
                }
                default: {
                    throw new XProcException("Default in getHeader?");
                }
            }
        }
        if ("".equals(name)) {
            return null;
        }
        name = name.trim();
        value = value.trim();
        return new BasicHeader(name, value);
    }

    public String getLine() {
        String line = "";
        boolean done = false;
        while (!done) {
            int b = this.nextByte();
            int peek = this.peekByte();
            if (b == 13) {
                if (peek == 10) {
                    b = this.nextByte();
                    peek = this.peekByte();
                } else {
                    b = 10;
                }
            }
            if (b < 0) {
                throw new XProcException("Got -1 reading stream...");
            }
            if (b == 10) {
                done = true;
                continue;
            }
            line = String.valueOf(line) + (char)b;
        }
        return line;
    }

    public InputStream readBodyPart(int contentLength) {
        String line;
        byte[] bodybytes = new byte[contentLength];
        int pos = 0;
        if (this.peek >= 0) {
            bodybytes[0] = (byte)this.peek;
            this.peek = -1;
            ++pos;
            --contentLength;
        }
        while (contentLength > 0) {
            try {
                int len = this.stream.read(bodybytes, pos, contentLength);
                if (len < 0) {
                    throw new XProcException("Read returned -1?");
                }
                pos += len;
                contentLength -= len;
            }
            catch (IOException ioe) {
                throw new XProcException(ioe);
            }
        }
        int peek = this.peekByte();
        if (peek == 13) {
            this.nextByte();
            peek = this.peekByte();
        }
        if (peek == 10) {
            this.nextByte();
        }
        if (!this.separator.equals(line = this.getLine()) && !this.lastsep.equals(line)) {
            throw new XProcException("MIME multipart missing separator?");
        }
        return new ByteArrayInputStream(bodybytes);
    }

    public InputStream readBodyPart() {
        int bodygrow = 4096;
        int bodysize = 16384;
        byte[] bodybytes = new byte[bodysize];
        boolean done = false;
        int bodyidx = 0;
        int sepidx = 0;
        int state = 4;
        while (!done) {
            int b = this.nextByte();
            if (b < 0) {
                throw new XProcException("Got -1 in readBodyPart?");
            }
            if (bodyidx == bodysize) {
                byte[] newbytes = new byte[bodysize + bodygrow];
                System.arraycopy(bodybytes, 0, newbytes, 0, bodysize);
                bodybytes = newbytes;
                bodysize += bodygrow;
            }
            char x = (char)b;
            bodybytes[bodyidx++] = (byte)b;
            switch (state) {
                case 4: 
                case 6: {
                    if (sepidx == this.separator.length()) {
                        if (b == 45) {
                            state = 8;
                            this.nextByte();
                            break;
                        }
                        if (b == 13 || b == 10) {
                            done = true;
                            bodyidx -= this.separator.length() + 3;
                            if (b != 13 || this.peekByte() != 10) break;
                            this.nextByte();
                            break;
                        }
                        state = 7;
                        sepidx = 0;
                        break;
                    }
                    if ((char)b == this.separator.charAt(sepidx)) {
                        state = 6;
                        ++sepidx;
                        break;
                    }
                    sepidx = 0;
                    if (b == 10) {
                        state = 4;
                        break;
                    }
                    state = 7;
                    break;
                }
                case 8: {
                    if (b == 13 || b == 10) {
                        done = true;
                        bodyidx -= this.separator.length() + 4;
                        if (b != 13 || this.peekByte() != 10) break;
                        this.nextByte();
                        break;
                    }
                    state = 7;
                    sepidx = 0;
                    break;
                }
                case 5: 
                case 7: {
                    if (b != 10) break;
                    state = 4;
                }
            }
            if (b != 13) continue;
            state = 5;
        }
        return new ByteArrayInputStream(bodybytes, 0, bodyidx);
    }

    private int peekByte() {
        if (this.peek >= 0) {
            return this.peek;
        }
        try {
            this.peek = this.stream.read();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        return this.peek;
    }

    private int nextByte() {
        if (this.peek >= 0) {
            int v = this.peek;
            this.peek = -1;
            return v;
        }
        try {
            return this.stream.read();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }
}

