/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class ProcessMatch
extends TreeWriter {
    public static final int SAW_ELEMENT = 1;
    public static final int SAW_WHITESPACE = 2;
    public static final int SAW_TEXT = 4;
    public static final int SAW_PI = 8;
    public static final int SAW_COMMENT = 16;
    private ProcessMatchingNodes processor = null;
    private int saw = 0;
    private XPathExpression matcher = null;
    private Configuration saxonConfig = null;
    private int count;

    public ProcessMatch(XProcRuntime runtime, ProcessMatchingNodes processor) {
        super(runtime);
        this.runtime = runtime;
        this.processor = processor;
        this.saxonConfig = runtime.getProcessor().getUnderlyingConfiguration();
    }

    public void match(XdmNode doc, RuntimeValue match) {
        XdmNode node = match.getNode();
        try {
            XPathEvaluator xeval = new XPathEvaluator(this.saxonConfig);
            MatchingNamespaceResolver resolver = new MatchingNamespaceResolver(match.getNamespaceBindings());
            xeval.setNamespaceResolver(resolver);
            this.matcher = xeval.createPattern(match.getString());
            this.destination = new XdmDestination();
            this.receiver = this.destination.getReceiver(this.saxonConfig);
            this.receiver = new NamespaceReducer(this.receiver);
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            pipe.setLocationProvider(this.xLocationProvider);
            this.receiver.setPipelineConfiguration(pipe);
            this.receiver.setSystemId(doc.getBaseURI().toASCIIString());
            this.receiver.open();
            if (doc.getNodeKind() != XdmNodeKind.DOCUMENT) {
                this.startDocument(doc.getBaseURI());
            }
            this.traverse(doc);
            if (doc.getNodeKind() != XdmNodeKind.DOCUMENT) {
                this.endDocument();
            }
            this.receiver.close();
        }
        catch (XProcException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("syntax error")) {
                throw XProcException.dynamicError(23, node, e, "Syntax error in match pattern: \"" + match.getString() + "\"");
            }
            throw XProcException.dynamicError(23, node, e, "Expression could not be evaluated");
        }
    }

    @Override
    public void startDocument(URI baseURI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.receiver.startDocument(0);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    public int count(XdmNode doc, RuntimeValue match, boolean deep) {
        this.count = 0;
        try {
            XPathEvaluator xeval = new XPathEvaluator(this.saxonConfig);
            MatchingNamespaceResolver resolver = new MatchingNamespaceResolver(match.getNamespaceBindings());
            xeval.setNamespaceResolver(resolver);
            this.matcher = xeval.createPattern(match.getString());
            this.traverse(doc, deep);
        }
        catch (XProcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
        return this.count;
    }

    @Override
    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean matches(XdmNode node) {
        try {
            XPathDynamicContext context = this.matcher.createDynamicContext(node.getUnderlyingNode());
            return this.matcher.effectiveBooleanValue(context);
        }
        catch (XPathException sae) {
            return false;
        }
    }

    private void traverse(XdmNode node) throws SaxonApiException, XPathException {
        boolean match = this.matches(node);
        boolean processChildren = false;
        if (!match) {
            if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
                this.saw |= 1;
            } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
                this.saw = "".equals(node.getStringValue().trim()) ? (this.saw |= 2) : (this.saw |= 4);
            } else if (node.getNodeKind() == XdmNodeKind.COMMENT) {
                this.saw |= 0x10;
            } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                this.saw |= 8;
            }
        }
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            if (match) {
                processChildren = this.processor.processStartDocument(node);
                this.saw = 0;
            } else {
                this.startDocument(node.getBaseURI());
            }
            if (!match || processChildren) {
                XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode child = (XdmNode)iter.next();
                    this.traverse(child);
                }
            }
            if (match) {
                this.processor.processEndDocument(node);
            } else {
                this.endDocument();
            }
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            XdmNode child;
            XdmSequenceIterator iter;
            if (match) {
                processChildren = this.processor.processStartElement(node);
                this.saw = 0;
            } else {
                this.addStartElement(node);
            }
            if (!match) {
                iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    if (this.matches(child)) continue;
                    this.traverse(child);
                }
                iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    if (!this.matches(child)) continue;
                    this.traverse(child);
                }
                this.receiver.startContent();
            }
            if (!match || processChildren) {
                iter = node.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    this.traverse(child);
                }
            }
            if (match) {
                this.processor.processEndElement(node);
            } else {
                this.addEndElement();
            }
        } else if (node.getNodeKind() == XdmNodeKind.ATTRIBUTE) {
            if (match) {
                this.processor.processAttribute(node);
                this.saw = 0;
            } else {
                this.addAttribute(node.getNodeName(), node.getStringValue());
            }
        } else if (node.getNodeKind() == XdmNodeKind.COMMENT) {
            if (match) {
                this.processor.processComment(node);
                this.saw = 0;
            } else {
                this.addComment(node.getStringValue());
            }
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            if (match) {
                this.processor.processText(node);
                this.saw = 0;
            } else {
                this.addText(node.getStringValue());
            }
        } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            if (match) {
                this.processor.processPI(node);
                this.saw = 0;
            } else {
                this.addPI(node.getNodeName().getLocalName(), node.getStringValue());
            }
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    private void traverse(XdmNode node, boolean deep) throws SaxonApiException, XPathException {
        block6: {
            boolean match;
            block5: {
                match = this.matches(node);
                if (match) {
                    ++this.count;
                }
                if (node.getNodeKind() != XdmNodeKind.DOCUMENT) break block5;
                if (match && !deep) break block6;
                XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode child = (XdmNode)iter.next();
                    this.traverse(child, deep);
                }
                break block6;
            }
            if (node.getNodeKind() == XdmNodeKind.ELEMENT && (!match || deep)) {
                XdmNode child;
                XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    this.traverse(child, deep);
                }
                iter = node.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    this.traverse(child, deep);
                }
            }
        }
    }

    private class MatchingNamespaceResolver
    implements NamespaceResolver {
        private Hashtable<String, String> ns = new Hashtable();

        public MatchingNamespaceResolver(Hashtable<String, String> bindings) {
            this.ns = bindings;
        }

        @Override
        public String getURIForPrefix(String prefix, boolean useDefault) {
            if ("".equals(prefix) && !useDefault) {
                return "";
            }
            return this.ns.get(prefix);
        }

        @Override
        public Iterator<String> iteratePrefixes() {
            Vector<String> p = new Vector<String>();
            for (String pfx : this.ns.keySet()) {
                p.add(pfx);
            }
            return p.iterator();
        }
    }
}

