/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class StepErrorListener
implements ErrorListener {
    private static QName c_error = new QName("http://www.w3.org/ns/xproc-step", "error");
    private static StructuredQName err_sxxp0003 = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "SXXP0003");
    private static QName _type = new QName("", "type");
    private static QName _href = new QName("", "href");
    private static QName _line = new QName("", "line");
    private static QName _column = new QName("", "column");
    private static QName _code = new QName("", "code");
    private XProcRuntime runtime = null;
    private URI baseURI = null;

    public StepErrorListener(XProcRuntime runtime) {
        this.runtime = runtime;
        this.baseURI = runtime.getStaticBaseURI();
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        if (!this.report("error", exception)) {
            this.runtime.error(exception);
        }
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        if (!this.report("fatal-error", exception)) {
            this.runtime.error(exception);
        }
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        if (!this.report("warning", exception)) {
            this.runtime.warning(exception);
        }
    }

    private boolean report(String type, TransformerException exception) {
        XPathException e;
        StructuredQName errqn;
        if (this.runtime.transparentJSON() && exception instanceof XPathException && (errqn = (e = (XPathException)exception).getErrorCodeQName()) != null && errqn.equals(err_sxxp0003)) {
            return true;
        }
        TreeWriter writer = new TreeWriter(this.runtime);
        writer.startDocument(this.baseURI);
        writer.addStartElement(c_error);
        String message = exception.toString();
        StructuredQName qCode = null;
        if (exception instanceof XPathException) {
            XPathException xxx = (XPathException)exception;
            qCode = xxx.getErrorCodeQName();
            Throwable underlying = exception.getException();
            if (underlying == null) {
                underlying = exception.getCause();
            }
            if (underlying != null) {
                message = underlying.toString();
            }
        }
        if (qCode == null && exception.getException() instanceof XPathException) {
            qCode = ((XPathException)exception.getException()).getErrorCodeQName();
        }
        if (qCode != null) {
            writer.addNamespace(qCode.getPrefix(), qCode.getNamespaceBinding().getURI());
            writer.addAttribute(_code, qCode.getDisplayName());
        }
        writer.addAttribute(_type, type);
        if (exception.getLocator() != null) {
            SourceLocator loc = exception.getLocator();
            boolean done = false;
            while (!done && loc == null) {
                if (exception.getException() instanceof TransformerException) {
                    exception = (TransformerException)exception.getException();
                    loc = exception.getLocator();
                    continue;
                }
                if (exception.getCause() instanceof TransformerException) {
                    exception = (TransformerException)exception.getCause();
                    loc = exception.getLocator();
                    continue;
                }
                done = true;
            }
            if (loc != null) {
                if (loc.getSystemId() != null && !"".equals(loc.getSystemId())) {
                    writer.addAttribute(_href, loc.getSystemId());
                }
                if (loc.getLineNumber() != -1) {
                    writer.addAttribute(_line, "" + loc.getLineNumber());
                }
                if (loc.getColumnNumber() != -1) {
                    writer.addAttribute(_column, "" + loc.getColumnNumber());
                }
            }
        }
        writer.startContent();
        writer.addText(message);
        writer.addEndElement();
        writer.endDocument();
        XdmNode node = writer.getResult();
        return this.runtime.getXProcData().catchError(node);
    }
}

