/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.XProcLocationProvider;
import java.net.URI;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TreeWriter {
    protected static final String logger = "com.xmlcalabash.util";
    protected Controller controller = null;
    protected XProcRuntime runtime = null;
    protected Executable exec = null;
    protected NamePool pool = null;
    protected XdmDestination destination = null;
    protected Receiver receiver = null;
    protected XProcLocationProvider xLocationProvider = null;
    protected boolean seenRoot = false;
    protected boolean inDocument = false;

    public TreeWriter(XProcRuntime xproc) {
        this.runtime = xproc;
        this.controller = new Controller(this.runtime.getProcessor().getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public TreeWriter(Processor proc) {
        this.controller = new Controller(proc.getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean inDocument() {
        return this.inDocument;
    }

    public void startDocument(URI baseURI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.exec = new Executable(this.controller.getConfiguration());
            this.destination = new XdmDestination();
            this.receiver = this.destination.getReceiver(this.controller.getConfiguration());
            this.receiver = new NamespaceReducer(this.receiver);
            PipelineConfiguration pipe = this.controller.makePipelineConfiguration();
            pipe.setLocationProvider(this.xLocationProvider);
            this.receiver.setPipelineConfiguration(pipe);
            if (baseURI != null) {
                this.receiver.setSystemId(baseURI.toASCIIString());
            } else {
                this.receiver.setSystemId("http://example.com/");
            }
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    public void endDocument() {
        try {
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addSubtree(XdmNode node) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            this.writeChildren(node);
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            this.addStartElement(node);
            XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                this.addAttribute(child, child.getStringValue());
            }
            try {
                this.receiver.startContent();
            }
            catch (XPathException xe) {
                throw new XProcException(xe);
            }
            this.writeChildren(node);
            this.addEndElement();
        } else if (node.getNodeKind() == XdmNodeKind.COMMENT) {
            this.addComment(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            this.addText(node.getStringValue());
        } else if (node.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.addPI(node.getNodeName().getLocalName(), node.getStringValue());
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    protected void writeChildren(XdmNode node) {
        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            this.addSubtree(child);
        }
    }

    public void addStartElement(XdmNode node) {
        NodeInfo inode = node.getUnderlyingNode();
        NamespaceBinding[] inscopeNS = null;
        if (this.seenRoot) {
            inscopeNS = inode.getDeclaredNamespaces(null);
        } else {
            int count = 0;
            Iterator<NamespaceBinding> nsiter = NamespaceIterator.iterateNamespaces(inode);
            while (nsiter.hasNext()) {
                ++count;
                nsiter.next();
            }
            inscopeNS = new NamespaceBinding[count];
            nsiter = NamespaceIterator.iterateNamespaces(inode);
            count = 0;
            while (nsiter.hasNext()) {
                inscopeNS[count] = nsiter.next();
                ++count;
            }
            this.seenRoot = true;
        }
        URI nodeBaseURI = node.getBaseURI();
        this.receiver.setSystemId(nodeBaseURI.toASCIIString());
        this.addStartElement(new NameOfNode(inode), inode.getSchemaType(), inscopeNS);
    }

    public void addStartElement(XdmNode node, QName newName) {
        NodeInfo inode = node.getUnderlyingNode();
        NamespaceBinding[] inscopeNS = null;
        if (this.seenRoot) {
            inscopeNS = inode.getDeclaredNamespaces(null);
        } else {
            int count = 0;
            Iterator<NamespaceBinding> nsiter = NamespaceIterator.iterateNamespaces(inode);
            while (nsiter.hasNext()) {
                ++count;
                nsiter.next();
            }
            inscopeNS = new NamespaceBinding[count];
            nsiter = NamespaceIterator.iterateNamespaces(inode);
            count = 0;
            while (nsiter.hasNext()) {
                inscopeNS[count] = nsiter.next();
                ++count;
            }
            this.seenRoot = true;
        }
        if ("".equals(newName.getPrefix())) {
            int newLen = 0;
            int pos = 0;
            while (pos < inscopeNS.length) {
                NamespaceBinding nscode = inscopeNS[pos];
                if (!"".equals(nscode.getPrefix())) {
                    ++newLen;
                }
                ++pos;
            }
            if (newLen != inscopeNS.length) {
                NamespaceBinding[] newCodes = new NamespaceBinding[newLen];
                int npos = 0;
                int pos2 = 0;
                while (pos2 < inscopeNS.length) {
                    NamespaceBinding nscode = inscopeNS[pos2];
                    if (!"".equals(nscode.getPrefix())) {
                        newCodes[npos++] = nscode;
                    }
                    ++pos2;
                }
                inscopeNS = newCodes;
            }
        }
        URI nodeBaseURI = node.getBaseURI();
        this.receiver.setSystemId(nodeBaseURI.toASCIIString());
        FingerprintedQName newNameOfNode = new FingerprintedQName(newName.getPrefix(), newName.getNamespaceURI(), newName.getLocalName());
        this.addStartElement(newNameOfNode, inode.getSchemaType(), inscopeNS);
    }

    public void addStartElement(QName newName) {
        FingerprintedQName elemName = new FingerprintedQName(newName.getPrefix(), newName.getNamespaceURI(), newName.getLocalName());
        SchemaType typeCode = BuiltInType.getSchemaType(630);
        NamespaceBinding[] inscopeNS = null;
        this.addStartElement(elemName, typeCode, inscopeNS);
    }

    public void addStartElement(NodeName elemName, SchemaType typeCode, NamespaceBinding[] nscodes) {
        String sysId = this.receiver.getSystemId();
        int locId = sysId == null ? 0 : this.xLocationProvider.allocateLocation(sysId);
        try {
            this.receiver.startElement(elemName, typeCode, locId, 0);
            if (nscodes != null) {
                NamespaceBinding[] namespaceBindingArray = nscodes;
                int n = nscodes.length;
                int n2 = 0;
                while (n2 < n) {
                    NamespaceBinding ns = namespaceBindingArray[n2];
                    this.receiver.namespace(ns, 0);
                    ++n2;
                }
            }
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addNamespace(String prefix, String uri) {
        NamespaceBinding nsbind = new NamespaceBinding(prefix, uri);
        try {
            this.receiver.namespace(nsbind, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttributes(XdmNode element) {
        XdmSequenceIterator iter = element.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            this.addAttribute(child);
        }
    }

    public void addAttribute(XdmNode xdmattr) {
        this.addAttribute(xdmattr, xdmattr.getStringValue());
    }

    public void addAttribute(XdmNode xdmattr, String newValue) {
        NodeInfo inode = xdmattr.getUnderlyingNode();
        NameOfNode attrName = new NameOfNode(inode);
        SimpleType typeCode = (SimpleType)inode.getSchemaType();
        try {
            this.receiver.attribute(attrName, typeCode, newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttribute(NodeName elemName, SimpleType typeCode, String newValue) {
        try {
            this.receiver.attribute(elemName, typeCode, newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addAttribute(QName attrName, String newValue) {
        FingerprintedQName elemName = new FingerprintedQName(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalName());
        SimpleType typeCode = (SimpleType)BuiltInType.getSchemaType(631);
        try {
            this.receiver.attribute(elemName, typeCode, newValue, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void startContent() {
        try {
            this.receiver.startContent();
        }
        catch (XPathException xe) {
            throw new XProcException(xe);
        }
    }

    public void addEndElement() {
        try {
            this.receiver.endElement();
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addComment(String comment) {
        try {
            this.receiver.comment(comment, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addText(String text) {
        try {
            this.receiver.characters(text, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }

    public void addPI(String target, String data) {
        try {
            this.receiver.processingInstruction(target, data, 0, 0);
        }
        catch (XPathException e) {
            throw new XProcException(e);
        }
    }
}

