/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.staxParser.AttributeInfo;
import net.sqf.xmlUtils.staxParser.DocumentInfo;
import net.sqf.xmlUtils.staxParser.ElementInfo;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.PositionalStaxParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PositionalXMLReader {
    public static final String NODE_INNER_LOCATION_START = "nils";
    public static final String NODE_INNER_LOCATION_END = "nile";
    public static final String NODE_LOCATION_START = "nls";
    public static final String NODE_LOCATION_END = "nle";
    public static final String ATTRIBUTE_REGION_LOCATION_START = "arls";
    public static final String ATTRIBUTE_REGION_LOCATION_END = "arle";
    public static final String DTD_LOCATION_START = "dls";
    public static final String DTD_LOCATION_END = "dle";
    public static final String XML_DECL_LOCATION_START = "xdls";
    public static final String XML_DECL_LOCATION_END = "xdle";
    public static final String ATTRIBUT_REGION = "ar";
    public static final int STANDARD_TYPE = 0;
    public static final int ELEMENT_START_TYPE = 1;
    public static final int ELEMENT_END_TYPE = 2;
    public static final int ATTRIBUTE_TYPE = 3;
    public static final int TEXT_TYPE = 4;
    public static final int DTD_TYPE = 5;
    public static final int DTD_TYPE_END = 6;
    protected static final String ELEMENT_ID = "elementId";
    public static final String HAS_DTD = "hasDTD";
    public static final String NAMESPACE_CONTEXT = "nsc";
    private int lineCounter = 0;
    private static final PositionalStaxParser woodStoxParser = PositionalXMLReader.initialParser();
    private boolean isWellformed = true;

    private static PositionalStaxParser initialParser() {
        return new PositionalStaxParser();
    }

    public static int getPosition(Node node, String userDataKey) {
        return PositionalXMLReader.getPosition(PositionalXMLReader.getNodeInfo(node), userDataKey);
    }

    private static int getPosition(NodeInfo info, String userDataKey) {
        if (userDataKey.equals(NODE_LOCATION_START)) {
            return info.getStartOffset();
        }
        if (userDataKey.equals(NODE_LOCATION_END)) {
            return info.getEndOffset();
        }
        if (info instanceof ElementInfo) {
            if (userDataKey.equals(NODE_INNER_LOCATION_END)) {
                return ((ElementInfo)info).getInnerEndOffset();
            }
            if (userDataKey.equals(NODE_INNER_LOCATION_START)) {
                return ((ElementInfo)info).getInnerStartOffset();
            }
            if (userDataKey.equals(ATTRIBUTE_REGION_LOCATION_START)) {
                return ((ElementInfo)info).getAttributRegionStartOffset();
            }
            if (userDataKey.equals(ATTRIBUTE_REGION_LOCATION_END)) {
                return ((ElementInfo)info).getAttributRegionEndOffset();
            }
        }
        if (info instanceof DocumentInfo) {
            if (userDataKey.equals(XML_DECL_LOCATION_START)) {
                return ((DocumentInfo)info).getXmlDeclStart().getCharacterOffset();
            }
            if (userDataKey.equals(XML_DECL_LOCATION_END)) {
                return ((DocumentInfo)info).getXmlDeclEnd().getCharacterOffset();
            }
            if (userDataKey.equals(DTD_LOCATION_START)) {
                return ((DocumentInfo)info).getDtdStart().getCharacterOffset();
            }
            if (userDataKey.equals(DTD_LOCATION_END)) {
                return ((DocumentInfo)info).getDtdEnd().getCharacterOffset();
            }
        }
        return -1;
    }

    public static int getLine(Node node, String userDataKey) {
        Location loc = (Location)node.getUserData(userDataKey);
        return loc.getLineNumber();
    }

    public boolean isWellformed(TextSource source) {
        return this.isWellformed(source.toString());
    }

    public boolean isWellformed(String source) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.isWellformed = true;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    PositionalXMLReader.this.isWellformed = false;
                }

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    PositionalXMLReader.this.isWellformed = false;
                }
            });
            docBuilder.parse(new InputSource(new StringReader(source)));
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return this.isWellformed;
    }

    public Document readXML(File doc) throws IOException, SAXException, XMLStreamException {
        TextSource ts = TextSource.readTextFile(doc);
        return this.readXML(ts);
    }

    public Document readXML(TextSource source) throws IOException, SAXException, XMLStreamException {
        Document docNode;
        ArrayList allNodes = new ArrayList();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docNode = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", e);
        }
        woodStoxParser.parse(docNode, source);
        docNode.setUserData("allNodes", allNodes, null);
        return docNode;
    }

    public static Location getLocation(Node node, String key) {
        return (Location)node.getUserData(key);
    }

    public static ElementInfo getNodeInfo(Element node) {
        return new ElementInfo(node);
    }

    public static NodeInfo getNodeInfo(Node node) {
        if (node instanceof Element) {
            return PositionalXMLReader.getNodeInfo((Element)node);
        }
        if (node instanceof Attr) {
            return PositionalXMLReader.getNodeInfo((Attr)node);
        }
        if (node instanceof Document) {
            return PositionalXMLReader.getNodeInfo((Document)node);
        }
        return new NodeInfo(node);
    }

    private static DocumentInfo getNodeInfo(Document node) {
        return new DocumentInfo(node);
    }

    private static NodeInfo getNodeInfo(Attr node) {
        return new AttributeInfo(node);
    }

    public static ArrayList<NodeInfo> getNodeInfo(NodeList nodes) {
        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
        int i = 0;
        while (i < nodes.getLength()) {
            nodeInfos.add(PositionalXMLReader.getNodeInfo(nodes.item(i)));
            ++i;
        }
        return nodeInfos;
    }
}

