/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xslt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Source;
import net.sqf.stringUtils.TextSource;
import net.sqf.utils.process.exceptions.CancelException;
import net.sqf.utils.process.log.ProcessLoger;
import net.sqf.xmlUtils.exceptions.XSLTErrorListener;
import net.sqf.xmlUtils.xslt.Parameter;
import net.sqf.xmlUtils.xslt.XSLTStep;

public class XSLTPipe {
    private ArrayList<XSLTStep> xsltSteps = new ArrayList();
    private ArrayList<ArrayList<TextSource>> tempResults = new ArrayList();
    private XSLTErrorListener errorListener = new XSLTErrorListener();
    private final String title;
    private Properties outputProps;

    public XSLTPipe(String title) {
        this.title = title;
    }

    public XSLTPipe(String title, Properties outputProperties) {
        this(title);
        this.outputProps = outputProperties;
    }

    public XSLTPipe(String title, XSLTErrorListener el) {
        this(title);
        this.errorListener = el;
    }

    public XSLTPipe(String title, Properties outputProperties, XSLTErrorListener el) {
        this(title, el);
        this.outputProps = outputProperties;
    }

    public void addStep(Source[] xsls) throws XSLTErrorListener {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(Source xsl) throws XSLTErrorListener {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(TextSource[] xsls) throws XSLTErrorListener {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(TextSource xsl) throws XSLTErrorListener {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(File[] xsls) throws XSLTErrorListener {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(File xsl) throws XSLTErrorListener {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(Source xsl, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    public void addStep(TextSource xsl, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    public void addStep(File xsl, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    private void addStep(XSLTStep step) {
        if (this.outputProps != null) {
            step.setOutputProperty(this.outputProps);
        }
        this.xsltSteps.add(step);
    }

    public void reset() {
        this.xsltSteps = new ArrayList();
    }

    public ArrayList<TextSource> pipe(File source, ArrayList<Parameter> params) throws IOException, XSLTErrorListener {
        return this.pipe(TextSource.readTextFile(source), params);
    }

    public ArrayList<TextSource> pipe(File source) throws IOException, XSLTErrorListener {
        return this.pipe(TextSource.readTextFile(source));
    }

    public ArrayList<TextSource> pipe(TextSource source) throws XSLTErrorListener {
        return this.pipe(source, new ArrayList<Parameter>());
    }

    public ArrayList<TextSource> pipe(TextSource source, ArrayList<Parameter> params) throws XSLTErrorListener {
        this.tempResults = new ArrayList();
        this.tempResults.add(new ArrayList());
        this.tempResults.get(this.tempResults.size() - 1).add(source);
        HashMap<Integer, ArrayList<Parameter>> paramByStep = this.createParamStepMap(params);
        int stepCounter = 0;
        for (XSLTStep step : this.xsltSteps) {
            ArrayList<Parameter> stepParam = paramByStep.containsKey(stepCounter) ? paramByStep.get(stepCounter) : new ArrayList<Parameter>();
            ArrayList<TextSource> temps = new ArrayList<TextSource>();
            for (TextSource tempResult : this.tempResults.get(this.tempResults.size() - 1)) {
                temps.add(step.transform(tempResult, stepParam));
                for (TextSource secResult : step.getSecondaryResults()) {
                    temps.add(secResult);
                }
            }
            this.tempResults.add(temps);
            ++stepCounter;
        }
        if (this.errorListener.hasErrors()) {
            throw this.errorListener;
        }
        return this.tempResults.get(this.tempResults.size() - 1);
    }

    public ArrayList<TextSource> pipe(TextSource source, ProcessLoger loger) {
        return this.pipe(source, new ArrayList<Parameter>(), loger);
    }

    public ArrayList<TextSource> pipe(TextSource source, ArrayList<Parameter> params, ProcessLoger loger) {
        try {
            ArrayList results = new ArrayList();
            return this.pipe(source, params);
        }
        catch (XSLTErrorListener e) {
            try {
                loger.log(e);
            }
            catch (CancelException e1) {
                return null;
            }
            return null;
        }
    }

    public TextSource pipeMain(TextSource source, ArrayList<Parameter> params) throws XSLTErrorListener {
        return this.pipe(source, params).get(0);
    }

    public TextSource pipeMain(TextSource source) throws XSLTErrorListener {
        return this.pipe(source).get(0);
    }

    public TextSource pipeMain(TextSource source, ProcessLoger loger) {
        return this.pipe(source, loger).get(0);
    }

    public TextSource pipeMain(TextSource source, ArrayList<Parameter> params, ProcessLoger loger) {
        return this.pipe(source, params, loger).get(0);
    }

    public ArrayList<TextSource> getTempResults() {
        ArrayList<TextSource> tempResults = new ArrayList<TextSource>();
        for (ArrayList<TextSource> result : this.tempResults) {
            tempResults.add(result.get(0));
        }
        return tempResults;
    }

    private HashMap<Integer, ArrayList<Parameter>> createParamStepMap(ArrayList<Parameter> paramList) {
        HashMap<Integer, ArrayList<Parameter>> paramByStep = new HashMap<Integer, ArrayList<Parameter>>();
        for (Parameter param : paramList) {
            if (paramByStep.containsKey(param.getStep())) {
                paramByStep.get(param.getStep()).add(param);
                continue;
            }
            ArrayList<Parameter> stepList = new ArrayList<Parameter>();
            stepList.add(param);
            paramByStep.put(param.getStep(), stepList);
        }
        return paramByStep;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProps = outputProperties;
    }
}

