/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import java.util.List;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataDerivFunction
extends AbstractPatternFunction<Pattern> {
    private final ValidatorPatternBuilder builder;
    private final ValidationContext vc;
    private final String str;
    private final List<DataDerivFailure> fail;

    DataDerivFunction(String string, ValidationContext validationContext, ValidatorPatternBuilder validatorPatternBuilder, List<DataDerivFailure> list) {
        this.str = string;
        this.vc = validationContext;
        this.builder = validatorPatternBuilder;
        this.fail = list;
    }

    static boolean isBlank(String string) {
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Pattern caseText(TextPattern textPattern) {
        return textPattern;
    }

    @Override
    public Pattern caseList(ListPattern listPattern) {
        int n = this.str.length();
        int n2 = 0;
        int n3 = -1;
        PatternMemo patternMemo = this.builder.getPatternMemo(listPattern.getOperand());
        block3: for (int i = 0; i < n; ++i) {
            switch (this.str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n3 < 0) continue block3;
                    patternMemo = this.tokenDeriv(patternMemo, n2++, n3, i);
                    n3 = -1;
                    continue block3;
                }
                default: {
                    if (n3 >= 0) continue block3;
                    n3 = i;
                }
            }
        }
        if (n3 >= 0) {
            patternMemo = this.tokenDeriv(patternMemo, n2++, n3, n);
        }
        if (patternMemo.getPattern().isNullable()) {
            return this.builder.makeEmpty();
        }
        if (patternMemo.isNotAllowed()) {
            return patternMemo.getPattern();
        }
        this.tokenDeriv(patternMemo, n2, n, n);
        return this.builder.makeNotAllowed();
    }

    private PatternMemo tokenDeriv(PatternMemo patternMemo, int n, int n2, int n3) {
        int n4 = this.failSize();
        PatternMemo patternMemo2 = patternMemo.dataDeriv(this.str.substring(n2, n3), this.vc, this.fail);
        if (this.fail != null && patternMemo2.isNotAllowed()) {
            for (int i = this.fail.size() - 1; i >= n4; --i) {
                this.fail.get(i).setToken(n, n2, n3);
            }
        }
        return patternMemo2;
    }

    @Override
    public Pattern caseValue(ValuePattern valuePattern) {
        Datatype datatype = valuePattern.getDatatype();
        Object object = datatype.createValue(this.str, this.vc);
        if (object != null && datatype.sameValue(valuePattern.getValue(), object)) {
            return this.builder.makeEmpty();
        }
        if (this.fail != null) {
            if (object == null) {
                try {
                    datatype.checkValid(this.str, this.vc);
                }
                catch (DatatypeException datatypeException) {
                    this.fail.add(new DataDerivFailure(datatype, valuePattern.getDatatypeName(), datatypeException));
                }
            } else {
                this.fail.add(new DataDerivFailure(valuePattern));
            }
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Pattern caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return this.builder.makeEmpty();
        }
        if (this.fail != null) {
            try {
                dataPattern.getDatatype().checkValid(this.str, this.vc);
                return this.builder.makeEmpty();
            }
            catch (DatatypeException datatypeException) {
                this.fail.add(new DataDerivFailure(dataPattern, datatypeException));
                return this.builder.makeNotAllowed();
            }
        }
        if (dataPattern.getDatatype().isValid(this.str, this.vc)) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Pattern caseDataExcept(DataExceptPattern dataExceptPattern) {
        Pattern pattern = this.caseData(dataExceptPattern);
        if (pattern.isNullable() && this.memoApply(dataExceptPattern.getExcept()).isNullable()) {
            if (this.fail != null) {
                this.fail.add(new DataDerivFailure(dataExceptPattern));
            }
            return this.builder.makeNotAllowed();
        }
        return pattern;
    }

    @Override
    public Pattern caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        int n = this.failSize();
        if (this.memoApplyWithFailure(pattern).isNullable()) {
            return afterPattern.getOperand2();
        }
        if (pattern.isNullable() && DataDerivFunction.isBlank(this.str)) {
            this.clearFailures(n);
            return afterPattern.getOperand2();
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Pattern caseChoice(ChoicePattern choicePattern) {
        int n = this.failSize();
        Pattern pattern = this.builder.makeChoice(this.memoApplyWithFailure(choicePattern.getOperand1()), this.memoApplyWithFailure(choicePattern.getOperand2()));
        if (!pattern.isNotAllowed()) {
            this.clearFailures(n);
        }
        return pattern;
    }

    @Override
    public Pattern caseGroup(GroupPattern groupPattern) {
        int n = this.failSize();
        Pattern pattern = groupPattern.getOperand1();
        Pattern pattern2 = groupPattern.getOperand2();
        Pattern pattern3 = this.builder.makeGroup(this.memoApplyWithFailure(pattern), pattern2);
        if (pattern.isNullable()) {
            pattern3 = this.builder.makeChoice(pattern3, this.memoApplyWithFailure(pattern2));
        }
        if (!pattern3.isNotAllowed()) {
            this.clearFailures(n);
        }
        return pattern3;
    }

    @Override
    public Pattern caseInterleave(InterleavePattern interleavePattern) {
        Pattern pattern = interleavePattern.getOperand1();
        Pattern pattern2 = interleavePattern.getOperand2();
        return this.builder.makeChoice(this.builder.makeInterleave(this.memoApply(pattern), pattern2), this.builder.makeInterleave(pattern, this.memoApply(pattern2)));
    }

    @Override
    public Pattern caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.builder.makeGroup(this.memoApplyWithFailure(oneOrMorePattern.getOperand()), this.builder.makeOptional(oneOrMorePattern));
    }

    @Override
    public Pattern caseOther(Pattern pattern) {
        return this.builder.makeNotAllowed();
    }

    private Pattern memoApply(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDeriv(this.str, this.vc).getPattern();
    }

    private Pattern memoApplyWithFailure(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDeriv(this.str, this.vc, this.fail).getPattern();
    }

    private int failSize() {
        return this.fail == null ? 0 : this.fail.size();
    }

    private void clearFailures(int n) {
        if (this.fail != null) {
            for (int i = this.fail.size() - 1; i >= n; --i) {
                this.fail.remove(i);
            }
        }
    }
}

