<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:es="http://www.escali.schematron-quickfix.com/" queryBinding="xslt2">
    <es:default-namespace uri="http://www.w3.org/1999/xhtml"/>
    <title>Schematron for the title</title>
    <pattern>
        <rule context="title">
            <let name="titleText" value="string-join(.//text(),'')"/>
            <report test="comment()" sqf:fix="deleteComment resolveComment" sqf:default-fix="deleteComment">Comments are forbidden in &lt;title&gt; elements.</report>
            <report test="string-length($titleText) gt 70" sqf:fix="cutTitle setTitle takeComment newTitle">The text in the &lt;title&gt; element is too long.</report>
            <report test="normalize-space($titleText) = ''" sqf:fix="setTitle newTitle">There is no title!</report>
            <sqf:fix id="deleteComment">
                <sqf:description>
                    <sqf:title>Delete the comment.</sqf:title>
                </sqf:description>
                <sqf:delete match="comment()"/>
            </sqf:fix>
            <sqf:fix id="resolveComment" use-when="not(string-length($titleText) + string-length(string-join(.//comment(),'')) gt 70)">
                <sqf:description>
                    <sqf:title>Change the comment into text.</sqf:title>
                </sqf:description>
                <sqf:replace match="comment()">
                    <value-of select="."/>
                </sqf:replace>
            </sqf:fix>
            <sqf:fix id="cutTitle">
                <sqf:description>
                    <sqf:title>Cut the title after the 70th character.</sqf:title>
                </sqf:description>
                <sqf:replace target="title" node-type="element">
                    <value-of select="substring(.,1,70)"/>
                </sqf:replace>
            </sqf:fix>
            <sqf:fix id="setTitle" use-when="//h1">
                <sqf:description>
                    <sqf:title>Take the title from the first headline.</sqf:title>
                </sqf:description>
                <sqf:replace target="title" node-type="element">
                    <value-of select="//h1[1]"/>
                </sqf:replace>
            </sqf:fix>
            <sqf:fix id="newTitle">
                <sqf:description>
                    <sqf:title>Set a new title.</sqf:title>
                </sqf:description>
                <sqf:user-entry name="newText" type="xs:string">
                    <sqf:description>
                        <sqf:title>Enter the text of the new title.</sqf:title>
                    </sqf:description>
                </sqf:user-entry>
                <sqf:replace target="title" node-type="element">
                    <value-of select="$newText"/>
                </sqf:replace>
            </sqf:fix>
            <sqf:fix id="takeComment" use-when="comment()">
                <sqf:description>
                    <sqf:title>Use the forbidden comment as new title.</sqf:title>
                </sqf:description>
                <sqf:replace target="title" node-type="element">
                    <value-of select="comment()"/>
                </sqf:replace>
            </sqf:fix>
        </rule>
    </pattern>
</schema>
