/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.staxParser.UserDataManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PositionalStaxParser {
    private Document doc;
    private byte[] docBytes;
    private String initialBaseUri = null;
    private ArrayList<Node> textBuffer = new ArrayList();
    private final Stack<Element> elementStack = new Stack();
    private UserDataManager udm;

    private void initialDoc(Document doc) {
        this.doc = doc;
        this.doc.setUserData("hasDTD", false, null);
    }

    public synchronized void parse(Document doc, TextSource docString) throws XMLStreamException, SAXException, UnsupportedEncodingException, IllegalStateException {
        this.initialDoc(doc);
        this.docBytes = docString.toString().getBytes(docString.getEncoding());
        this.udm = new UserDataManager(doc, docString.toString());
        ByteArrayInputStream is = new ByteArrayInputStream(this.docBytes);
        String orgParser = System.getProperty("javax.xml.stream.XMLInputFactory");
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        if (orgParser != null) {
            System.setProperty("javax.xml.stream.XMLInputFactory", orgParser);
        }
        this.initialBaseUri = docString.getFile().toURI().toString();
        doc.setDocumentURI(this.initialBaseUri);
        XMLStreamReader event = inputFactory.createXMLStreamReader(this.initialBaseUri, is);
        while (event.hasNext()) {
            switch (event.getEventType()) {
                case 7: {
                    this.startDocument(event);
                    break;
                }
                case 1: {
                    this.startElement(event);
                    break;
                }
                case 2: {
                    this.endElement(event);
                    break;
                }
                case 11: {
                    this.endDTD(event);
                    break;
                }
                case 5: {
                    this.comment(event);
                    break;
                }
                case 4: {
                    this.characters(event);
                    break;
                }
                case 8: {
                    event.next();
                    break;
                }
                case 10: {
                    event.next();
                    break;
                }
                case 15: {
                    event.next();
                    break;
                }
                case 9: {
                    event.next();
                    break;
                }
                case 13: {
                    event.next();
                    break;
                }
                case 3: {
                    this.processingInstruction(event);
                    break;
                }
                case 6: {
                    this.characters(event);
                    break;
                }
                case 12: {
                    event.next();
                    break;
                }
                default: {
                    event.next();
                }
            }
        }
    }

    private void startDocument(XMLStreamReader event) throws XMLStreamException {
        this.elementStack.removeAllElements();
        this.textBuffer = new ArrayList();
        this.udm.setXmlDeclaration(event);
    }

    private void endDTD(XMLStreamReader event) throws XMLStreamException {
        this.udm.setDTD(event);
    }

    private void startElement(XMLStreamReader event) throws XMLStreamException {
        this.addTextIfNeeded();
        QName name = event.getName();
        Element el = this.doc.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        el.setPrefix(name.getPrefix());
        int i = 0;
        while (i < event.getAttributeCount()) {
            String attrName = event.getAttributeLocalName(i);
            String ns = event.getAttributeNamespace(i);
            String prefix = event.getAttributePrefix(i);
            if (ns == null || ns.equals("")) {
                el.setAttribute(attrName, event.getAttributeValue(i));
            } else {
                el.setAttributeNS(ns, attrName, event.getAttributeValue(i));
                el.getAttributeNodeNS(ns, attrName).setPrefix(prefix);
            }
            Attr attr = el.getAttributeNode(attrName);
            ++i;
        }
        this.baseUri(el);
        this.udm.setStartElement(el, event);
        this.elementStack.push(el);
    }

    private void endElement(XMLStreamReader event) throws XMLStreamException {
        this.addTextIfNeeded();
        Element closedEl = this.elementStack.pop();
        if (this.elementStack.isEmpty()) {
            this.doc.appendChild(closedEl);
        } else {
            Element parentEl = this.elementStack.peek();
            parentEl.appendChild(closedEl);
        }
        this.udm.setEndElement(closedEl, event);
    }

    private void characters(XMLStreamReader event) throws SAXException, XMLStreamException {
        String appendText = event.getText();
        Text textNode = this.doc.createTextNode(appendText);
        this.textBuffer.add(textNode);
        this.udm.setNode(textNode, event, true);
    }

    private void processingInstruction(XMLStreamReader event) throws XMLStreamException, IllegalStateException {
        this.addTextIfNeeded();
        Document el = this.elementStack.isEmpty() ? this.doc : (Node)this.elementStack.peek();
        ProcessingInstruction pi = this.doc.createProcessingInstruction(event.getPITarget(), event.getPIData());
        el.appendChild(pi);
        this.udm.setNode(pi, event);
    }

    private void comment(XMLStreamReader event) throws XMLStreamException {
        this.addTextIfNeeded();
        Document el = this.elementStack.isEmpty() ? this.doc : (Node)this.elementStack.peek();
        String comment = event.getText();
        Comment commentNode = this.doc.createComment(comment);
        el.appendChild(commentNode);
        this.udm.setNode(commentNode, event);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.size() > 0) {
            String textBuffer = "";
            for (Node textNode : this.textBuffer) {
                textBuffer = String.valueOf(textBuffer) + textNode.getNodeValue();
            }
            Node el = this.elementStack.peek();
            Text newTextNode = this.doc.createTextNode(textBuffer);
            this.udm.appendToTextNodeBundle(newTextNode, this.textBuffer);
            el.appendChild(newTextNode);
            this.textBuffer = new ArrayList();
        }
    }

    private void baseUri(Element node) {
        if (this.elementStack.isEmpty()) {
            node.setAttributeNS("http://www.w3.org/XML/1998/namespace", "base", this.initialBaseUri);
        }
    }
}

