/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class Uncompress
extends DefaultStep {
    protected static final String logger = "com.xmlcalabash.extensions.gunzip";
    private static final QName _compression_method = new QName("compression-method");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public Uncompress(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String cmethod = this.getOption(_compression_method, "gzip");
        if (!"gzip".equals(cmethod)) {
            throw XProcException.stepError(999, "The only compression method supported is 'gzip'.");
        }
        XdmNode root = S9apiUtils.getDocumentElement(this.source.read());
        byte[] decoded = null;
        if (!"base64".equals(root.getAttributeValue(_encoding))) {
            throw XProcException.stepError(999, "Input to cx:gunzip must be binary encoded data.");
        }
        decoded = Base64.decode(root.getStringValue());
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
            InputSource is = new InputSource(bais);
            XdmNode doc = this.runtime.parse(is);
            this.result.write(doc);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }
}

