/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class DefaultStep
implements XProcStep {
    public static final QName _byte_order_mark = new QName("", "byte-order-mark");
    public static final QName _cdata_section_elements = new QName("", "cdata-section-elements");
    public static final QName _doctype_public = new QName("", "doctype-public");
    public static final QName _doctype_system = new QName("", "doctype-system");
    public static final QName _encoding = new QName("", "encoding");
    public static final QName _escape_uri_attributes = new QName("", "escape-uri-attributes");
    public static final QName _include_content_type = new QName("", "include-content-type");
    public static final QName _indent = new QName("", "indent");
    public static final QName _media_type = new QName("", "media-type");
    public static final QName _method = new QName("", "method");
    public static final QName _normalization_form = new QName("", "normalization-form");
    public static final QName _omit_xml_declaration = new QName("", "omit-xml-declaration");
    public static final QName _standalone = new QName("", "standalone");
    public static final QName _undeclare_prefixes = new QName("", "undeclare-prefixes");
    public static final QName _version = new QName("", "version");
    private Hashtable<QName, RuntimeValue> options = null;
    protected XProcRuntime runtime = null;
    protected XAtomicStep step = null;
    protected Logger logger = Logger.getLogger(this.getClass().getName());

    public DefaultStep(XProcRuntime runtime, XAtomicStep step) {
        this.runtime = runtime;
        this.step = step;
    }

    public XAtomicStep getStep() {
        return this.step;
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        throw new XProcException("No inputs allowed.");
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        throw new XProcException("No outputs allowed.");
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        throw new XProcException("No parameters allowed.");
    }

    @Override
    public void setParameter(String port, QName name, RuntimeValue value) {
        throw new XProcException("No parameters allowed on port '" + port + "'");
    }

    @Override
    public void setOption(QName name, RuntimeValue value) {
        if (this.options == null) {
            this.options = new Hashtable();
        }
        this.options.put(name, value);
    }

    public RuntimeValue getOption(QName name) {
        if (this.options != null && this.options.containsKey(name)) {
            return this.options.get(name);
        }
        return null;
    }

    public String getOption(QName name, String defaultValue) {
        if (this.options == null || !this.options.containsKey(name)) {
            return defaultValue;
        }
        return this.options.get(name).getString();
    }

    public QName getOption(QName name, QName defaultValue) {
        if (this.options == null || !this.options.containsKey(name)) {
            return defaultValue;
        }
        return this.options.get(name).getQName();
    }

    public boolean getOption(QName name, boolean defaultValue) {
        if (this.options == null || !this.options.containsKey(name)) {
            return defaultValue;
        }
        return this.options.get(name).getBoolean();
    }

    public int getOption(QName name, int defaultValue) {
        if (this.options == null || !this.options.containsKey(name)) {
            return defaultValue;
        }
        return this.options.get(name).getInt();
    }

    @Override
    public void reset() {
        throw new XProcException("XProcStep implementation must override reset().");
    }

    public void error(XdmNode node, String message, QName code) {
        this.runtime.error(this, node, message, code);
    }

    public void warning(XdmNode node, String message) {
        this.runtime.warning(this, node, message);
    }

    public void info(XdmNode node, String message) {
        this.runtime.info(this, node, message);
    }

    public void fine(XdmNode node, String message) {
        this.runtime.fine(this, node, message);
    }

    public void finer(XdmNode node, String message) {
        this.runtime.finer(this, node, message);
    }

    public void finest(XdmNode node, String message) {
        this.runtime.finest(this, node, message);
    }

    @Override
    public void run() throws SaxonApiException {
        String type = null;
        type = "http://www.w3.org/ns/xproc".equals(this.step.getType().getNamespaceURI()) ? this.step.getType().getLocalName() : this.step.getType().getClarkName();
        this.fine(null, "Running " + type + " " + this.step.getName());
    }

    public Serializer makeSerializer() {
        String list;
        Serializer serializer = new Serializer();
        if (this.options == null) {
            return serializer;
        }
        if (this.options.containsKey(_byte_order_mark)) {
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, this.getOption(_byte_order_mark, false) ? "yes" : "no");
        }
        if (this.options.containsKey(_cdata_section_elements) && !"".equals(list = this.getOption(_cdata_section_elements).getString())) {
            String[] names = list.split("\\s+");
            list = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                QName q = new QName(name, this.step.getNode());
                list = String.valueOf(list) + q.getClarkName() + " ";
                ++n2;
            }
            serializer.setOutputProperty(Serializer.Property.CDATA_SECTION_ELEMENTS, list);
        }
        if (this.options.containsKey(_doctype_public)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, this.getOption(_doctype_public).getString());
        }
        if (this.options.containsKey(_doctype_system)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, this.getOption(_doctype_system).getString());
        }
        if (this.options.containsKey(_encoding)) {
            serializer.setOutputProperty(Serializer.Property.ENCODING, this.getOption(_encoding).getString());
        }
        if (this.options.containsKey(_escape_uri_attributes)) {
            serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, this.getOption(_escape_uri_attributes, true) ? "yes" : "no");
        }
        if (this.options.containsKey(_include_content_type)) {
            serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, this.getOption(_include_content_type, true) ? "yes" : "no");
        }
        if (this.options.containsKey(_indent)) {
            serializer.setOutputProperty(Serializer.Property.INDENT, this.getOption(_indent, true) ? "yes" : "no");
        }
        if (this.options.containsKey(_media_type)) {
            serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, this.getOption(_media_type).getString());
        }
        if (this.options.containsKey(_method)) {
            serializer.setOutputProperty(Serializer.Property.METHOD, this.getOption(_method).getString());
        }
        if (this.options.containsKey(_normalization_form)) {
            serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, this.getOption(_normalization_form).getString());
        }
        if (this.options.containsKey(_omit_xml_declaration)) {
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, this.getOption(_omit_xml_declaration, true) ? "yes" : "no");
        }
        if (this.options.containsKey(_standalone)) {
            String standalone = this.getOption(_standalone).getString();
            if ("true".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
            } else if ("false".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
            }
        }
        if (this.options.containsKey(_undeclare_prefixes)) {
            serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, this.getOption(_undeclare_prefixes, true) ? "yes" : "no");
        }
        if (this.options.containsKey(_version)) {
            serializer.setOutputProperty(Serializer.Property.VERSION, this.getOption(_version).getString());
        }
        return serializer;
    }

    public Vector<XdmItem> evaluateXPath(XdmNode doc, Hashtable<String, String> nsBindings, String xpath, Hashtable<QName, RuntimeValue> globals) {
        Vector<XdmItem> results = new Vector<XdmItem>();
        Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
        try {
            XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
            xcomp.setBaseURI(this.step.getNode().getBaseURI());
            for (QName varname : globals.keySet()) {
                xcomp.declareVariable(varname);
            }
            for (String prefix : nsBindings.keySet()) {
                xcomp.declareNamespace(prefix, nsBindings.get(prefix));
            }
            XPathExecutable xexec = null;
            try {
                xexec = xcomp.compile(xpath);
            }
            catch (SaxonApiException sae) {
                XPathException xe;
                Throwable t = sae.getCause();
                if (t instanceof XPathException && (xe = (XPathException)t).getMessage().contains("Undeclared variable")) {
                    throw XProcException.dynamicError(26, xe.getMessage());
                }
                throw sae;
            }
            XPathSelector selector = xexec.load();
            for (QName varname : globals.keySet()) {
                XdmAtomicValue avalue = globals.get(varname).getUntypedAtomic(this.runtime);
                selector.setVariable(varname, avalue);
            }
            if (doc != null) {
                selector.setContextItem(doc);
            }
            try {
                Iterator<XdmItem> values = selector.iterator();
                while (values.hasNext()) {
                    results.add(values.next());
                }
            }
            catch (SaxonApiUncheckedException saue) {
                Throwable sae = saue.getCause();
                if (sae instanceof XPathException) {
                    XPathException xe = (XPathException)sae;
                    if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, "Expression refers to context when none is available: " + xpath);
                    }
                    throw saue;
                }
                throw saue;
            }
        }
        catch (SaxonApiException sae) {
            if (S9apiUtils.xpathSyntaxError(sae)) {
                throw XProcException.dynamicError(23, "Invalid XPath expression: '" + xpath + "'.");
            }
            throw new XProcException(sae);
        }
        return results;
    }
}

