/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class DirectoryList
extends DefaultStep {
    private static final QName _name = new QName("", "name");
    private static final QName _path = new QName("", "path");
    private static final QName _include_filter = new QName("", "include-filter");
    private static final QName _exclude_filter = new QName("", "exclude-filter");
    private static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    private static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    private static final QName c_other = new QName("c", "http://www.w3.org/ns/xproc-step", "other");
    private static final QName px_show_excluded = new QName("http://xmlcalabash.com/ns/extensions", "show-excluded");
    private WritablePipe result = null;
    private String path = ".";
    private String inclFilter = null;
    private String exclFilter = null;

    public DirectoryList(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        File[] contents;
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        if (this.getOption(_path) != null) {
            URI pathbase = this.getOption(_path).getBaseURI();
            String pathstr = URIUtils.encode(this.getOption(_path).getString());
            this.path = pathbase.resolve(pathstr).toASCIIString();
        } else {
            this.path = this.step.getNode().getBaseURI().resolve(".").toASCIIString();
        }
        this.runtime.finer(null, this.step.getNode(), "path: " + this.path);
        RuntimeValue value = this.getOption(_include_filter);
        if (value != null) {
            this.inclFilter = value.getString();
            this.runtime.finer(null, this.step.getNode(), "include: " + this.inclFilter);
        }
        if ((value = this.getOption(_exclude_filter)) != null) {
            this.exclFilter = value.getString();
            this.runtime.finer(null, this.step.getNode(), "exclude: " + this.exclFilter);
        }
        File dir = URIUtils.getFile(this.path);
        String dirname = null;
        try {
            dir = dir.getCanonicalFile();
            dirname = dir.getName();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        if (!dir.isDirectory()) {
            throw XProcException.stepError(17);
        }
        if (!dir.canRead()) {
            throw XProcException.stepError(12);
        }
        boolean showExcluded = "true".equals(this.step.getExtensionAttribute(px_show_excluded));
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_directory);
        tree.addAttribute(_name, dirname);
        tree.addAttribute(XProcConstants.xml_base, dir.toURI().toASCIIString());
        tree.startContent();
        File[] fileArray = contents = dir.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            boolean use = true;
            String filename = file.getName();
            this.runtime.finer(null, this.step.getNode(), "name: " + filename);
            if (this.inclFilter != null) {
                use = filename.matches(this.inclFilter);
                this.runtime.finer(null, this.step.getNode(), "include: " + use);
            }
            if (this.exclFilter != null) {
                use = use && !filename.matches(this.exclFilter);
                this.runtime.finer(null, this.step.getNode(), "exclude: " + !use);
            }
            if (use) {
                if (file.isDirectory()) {
                    tree.addStartElement(c_directory);
                    tree.addAttribute(_name, file.getName());
                    tree.addEndElement();
                    this.finest(this.step.getNode(), "Including directory: " + file.getName());
                } else if (file.isFile()) {
                    tree.addStartElement(c_file);
                    tree.addAttribute(_name, file.getName());
                    tree.addEndElement();
                    this.finest(this.step.getNode(), "Including file: " + file.getName());
                } else {
                    tree.addStartElement(c_other);
                    tree.addAttribute(_name, file.getName());
                    tree.addEndElement();
                    this.finest(this.step.getNode(), "Including other: " + file.getName());
                }
            } else if (showExcluded) {
                tree.addComment(" excluded: " + file.getName() + " ");
                this.finest(this.step.getNode(), "Excluding: " + file.getName());
            }
            ++n2;
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

