/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.CollectionResolver;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

public class XQuery
extends DefaultStep {
    private static final QName _content_type = new QName("content-type");
    private ReadablePipe source = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private ReadablePipe query = null;
    private WritablePipe result = null;

    public XQuery(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("query".equals(port)) {
            this.query = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.query.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
        while (this.source.moreDocuments()) {
            defaultCollection.add(this.source.read());
        }
        XdmNode document = null;
        if (defaultCollection.size() > 0) {
            document = (XdmNode)defaultCollection.firstElement();
        }
        XdmNode root = S9apiUtils.getDocumentElement(this.query.read());
        String queryString = null;
        if (XProcConstants.c_data.equals(root.getNodeName()) && "application/octet-stream".equals(root.getAttributeValue(_content_type)) || "base64".equals(root.getAttributeValue(_encoding))) {
            byte[] decoded = Base64.decode(root.getStringValue());
            queryString = new String(decoded);
        } else {
            queryString = root.getStringValue();
        }
        Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXQuery(config);
        CollectionURIResolver collectionResolver = config.getCollectionURIResolver();
        config.setCollectionURIResolver(new CollectionResolver(this.runtime, defaultCollection, collectionResolver));
        try {
            Processor qtproc = this.runtime.getProcessor();
            XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
            xqcomp.setBaseURI(root.getBaseURI());
            xqcomp.setModuleURIResolver(this.runtime.getResolver());
            XQueryExecutable xqexec = xqcomp.compile(queryString);
            XQueryEvaluator xqeval = xqexec.load();
            if (document != null) {
                xqeval.setContextItem(document);
            }
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                if (this.runtime.getAllowGeneralExpressions()) {
                    xqeval.setExternalVariable(name, v.getValue());
                    continue;
                }
                xqeval.setExternalVariable(name, new XdmAtomicValue(v.getString()));
            }
            for (XdmItem item : xqeval) {
                if (item.isAtomicValue()) {
                    throw new XProcException(this.step.getNode(), "Not expecting atomic values back from XQuery!");
                }
                XdmNode node = (XdmNode)item;
                if (node.getNodeKind() != XdmNodeKind.DOCUMENT) {
                    TreeWriter treeWriter = new TreeWriter(this.runtime);
                    treeWriter.startDocument(this.step.getNode().getBaseURI());
                    treeWriter.addSubtree(node);
                    treeWriter.endDocument();
                    node = treeWriter.getResult();
                }
                this.result.write(node);
            }
        }
        finally {
            config.setCollectionURIResolver(collectionResolver);
        }
    }
}

