/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.TreeWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XPipeline
extends XCompoundStep {
    private static final QName c_param_set = new QName("c", "http://www.w3.org/ns/xproc-step", "param-set");
    private static final QName c_param = new QName("c", "http://www.w3.org/ns/xproc-step", "param");
    private static final QName _name = new QName("name");
    private static final QName _namespace = new QName("namespace");
    private static final QName _value = new QName("value");
    private Hashtable<QName, RuntimeValue> optionsPassedIn = null;

    public XPipeline(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public void passOption(QName name, RuntimeValue value) {
        if (this.optionsPassedIn == null) {
            this.optionsPassedIn = new Hashtable();
        }
        this.optionsPassedIn.put(name, value);
    }

    @Override
    public Hashtable<QName, RuntimeValue> getInScopeOptions() {
        Hashtable<QName, RuntimeValue> globals = new Hashtable<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName name : this.inScopeOptions.keySet()) {
                globals.put(name, (RuntimeValue)this.inScopeOptions.get(name));
            }
        }
        if (this.optionsPassedIn != null) {
            for (QName name : this.optionsPassedIn.keySet()) {
                globals.put(name, this.optionsPassedIn.get(name));
            }
        }
        return globals;
    }

    public Set<String> getInputs() {
        HashSet<String> ports = new HashSet<String>();
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            ports.add(port);
        }
        return ports;
    }

    public void clearInputs(String port) {
        Vector v = (Vector)this.inputs.get(port);
        v.clear();
    }

    public void writeTo(String port, XdmNode node) {
        WritablePipe pipe = (WritablePipe)this.outputs.get(String.valueOf(port) + "|");
        this.finest(this.step.getNode(), "writesTo " + pipe + " for " + port);
        pipe.write(node);
    }

    public Set<String> getOutputs() {
        HashSet<String> ports = new HashSet<String>();
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            ports.add(port);
        }
        return ports;
    }

    public ReadablePipe readFrom(String port) {
        ReadablePipe rpipe = null;
        XOutput output = this.getOutput(port);
        rpipe = output.getReader();
        rpipe.canReadSequence(true);
        return rpipe;
    }

    public Serialization getSerialization(String port) {
        Output output = this.step.getOutput(port);
        return output.getSerialization();
    }

    @Override
    public void run() throws SaxonApiException {
        QName infoName = XProcConstants.p_pipeline;
        this.fine(null, "Running " + infoName + " " + this.step.getName());
        if (this.runtime.getAllowGeneralExpressions()) {
            this.fine(this.step.getNode(), "Running with the 'general-values' extension enabled.");
        }
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        this.runtime.start(this);
        try {
            this.doRun();
        }
        catch (XProcException ex) {
            this.runtime.error(ex);
            throw ex;
        }
        catch (SaxonApiException ex) {
            this.runtime.error(ex);
            throw ex;
        }
        this.runtime.finish(this);
        data.closeFrame();
    }

    private void setupParameters() {
        Vector<String> ports = new Vector<String>();
        Iterator<String> portIter = this.getParameterPorts().iterator();
        while (portIter.hasNext()) {
            ports.add(portIter.next());
        }
        for (String port : ports) {
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(c_param_set);
            tree.startContent();
            for (QName name : this.getParameters(port)) {
                String value = this.getParameter(port, name).getString();
                tree.addStartElement(c_param);
                tree.addAttribute(_name, name.getLocalName());
                if (name.getNamespaceURI() != null) {
                    tree.addAttribute(_namespace, name.getNamespaceURI());
                }
                tree.addAttribute(_value, value);
                tree.startContent();
                tree.addEndElement();
            }
            tree.addEndElement();
            tree.endDocument();
            this.writeTo(port, tree.getResult());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doRun() throws SaxonApiException {
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            wport = String.valueOf(port) + "|";
            pipe = (WritablePipe)this.outputs.get(wport);
            for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                while (reader.moreDocuments()) {
                    doc = reader.read();
                    pipe.write(doc);
                    this.finest(this.step.getNode(), "Pipeline input copy from " + reader + " to " + pipe);
                }
            }
        }
        this.setupParameters();
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName name : this.step.getOptions()) {
            option = this.step.getOption(name);
            value = null;
            if (this.optionsPassedIn != null && this.optionsPassedIn.containsKey(name)) {
                value = this.optionsPassedIn.get(name);
            } else {
                if (option.getRequired() && option.getSelect() == null) {
                    throw XProcException.staticError(18, option.getNode(), "No value provided for required option \"" + option.getName() + "\"");
                }
                value = option.getSelect() == null ? new RuntimeValue() : this.computeValue(option);
            }
            this.setOption(name, value);
            this.inScopeOptions.put(name, value);
        }
        for (Variable var : this.step.getVariables()) {
            value = this.computeValue(var);
            this.inScopeOptions.put(var.getName(), value);
        }
        for (XStep step : this.subpipeline) {
            step.run();
        }
        for (String port : this.inputs.keySet()) {
            if (!port.startsWith("|")) continue;
            wport = port.substring(1);
            pipe = (WritablePipe)this.outputs.get(wport);
            for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                if (reader.moreDocuments() || pipe.writeSequence()) ** GOTO lbl46
                throw XProcException.dynamicError(7);
lbl-1000:
                // 1 sources

                {
                    doc = reader.read();
                    pipe.write(doc);
                    this.finest(this.step.getNode(), "Pipeline output copy from " + reader + " to " + pipe);
lbl46:
                    // 2 sources

                    ** while (reader.moreDocuments())
                }
lbl47:
                // 1 sources

            }
            pipe.close();
        }
    }
}

